/*
 * Toolkit GUI, an application built for operating pinkRF's signal generators.
 *
 * Contact: https://www.pinkrf.com/contact/
 * Copyright © 2018-2024 pinkRF B.V
 * GNU General Public License version 3.
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with this program. If not, see https://www.gnu.org/licenses/
 *
 * Author: Iordan Svechtarov
 */

#ifndef RF_SYSTEM_4CHANNEL_H
#define RF_SYSTEM_4CHANNEL_H
#include "rf_system.h"
#include "rotaryswitch.h"
#include <QThread>

#ifdef ETHERCAT
	#include "ethercat/module.h"
	#include "ethercat/signalsslots.h"
#endif

//
// TODO:
// Consider moving away from this hardcoded CHANNELCOUNT value?
// Can use config->get_channel_count() instead. Makes GUI a bit more flexible in terms of configuration options... I think?
//

#define CHANNELCOUNT 4

class RF_System_4channel : public QObject
{
	Q_OBJECT


public:
	RF_System_4channel();
	~RF_System_4channel();

	QList<QThread*> *threadList;

	Serial *RCM_USB_port;
	ConfigHandler *config;

	/* EtherCAT stuff */
#ifdef ETHERCAT
	EtherCATSignalsSlots_4channel *ethercatSs;
	EtherCATModule ethercatModule;
#endif

	int channelCount();


private:	
	QThread *channelThread;
	RF_Channel *channel;
	int channel_count = CHANNELCOUNT;

	RotarySwitch *rotary_switch;

	QStringList probe_serialports();

	void RCM_USB_message_handler();
	void RCM_USB_response_handler(QString response);


private slots:
	void RCM_USB_error_handler(QSerialPort::SerialPortError error);


signals:
	void signal_RCM_USB_message(QString message);


};

#endif //RF_SYSTEM_4CHANNEL_H
